const path = require('path');
const HtmlWebpackPlugin = require('html-webpack-plugin');
const CopyWebpackPlugin = require('copy-webpack-plugin');


module.exports = {
  entry: './public/index.html',  // If you want to use HTML as the entry point
  output: {
    filename: 'bundle.js',
    path: path.resolve(__dirname, 'dist'),
  },
  module: {
    rules: [
      {
        test: /\.html$/,
        use: 'html-loader'
      }
    ]
  },
  plugins: [
    new HtmlWebpackPlugin({
      template: './public/index.html',  // Your HTML file as the template
    }),
    new CopyWebpackPlugin({
      patterns: [
        { from: 'manifest.json', to: '' },  // Copy manifest.json to dist/
        { from: 'icons', to: 'icons' } 
      ],
    }),
  ],
  mode: 'development',  // Or 'production' for a production build
};