// Retrieve credentials from local storage
chrome.storage.local.get("credentials", res => {
  // Check if there was an error during retrieval
  if (chrome.runtime.lastError) {
    console.error("Error retrieving credentials:", chrome.runtime.lastError);
    return;
  }

  // Get the credentials object from the storage response, default to an empty object if not found
  const creds = res.credentials || {};
  // Get the hostname of the current domain
  const domain = location.hostname;
  // Get the list of credentials for the current domain, default to an empty array if not found
  const list = creds[domain] || [];
  // If there are no credentials for this domain, exit the function
  if (!list.length) return;

  // Get the first set of credentials from the list
  const { username, password } = list[0];
  // Find the username field (either text or email type)
  const userField = document.querySelector("input[type='text'], input[type='email']");
  // Find the password field
  const passField = document.querySelector("input[type='password']");

  // If a username field is found, set its value to the stored username
  if (userField) userField.value = username;
  // If a password field is found, set its value to the stored password
  if (passField) passField.value = password;
});